﻿<%@ Page Title="Patient Workflows" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" 
    CodeBehind="PatientWorkflows.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.PatientWorkflows" MaintainScrollPositionOnPostback = "true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    <script src="<%: ResolveUrl("~/Scripts/Custom/EFR/scrollsaver.js") %>"></script>
</asp:Content> 

<asp:Content ID="Content2" ContentPlaceHolderID = "MainContent" Runat="Server">
    
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
               
    </style>          

    <asp:ValidationSummary ID="ValidationSummaryPatientWorflows" runat="server" HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="True" /> 

     <asp:Repeater ID = "EFRPatientReferrals" runat = "server"  
        OnItemCommand = "EFRPatientReferrals_ItemCommand"
        OnItemCreated = "EFRPatientReferrals_ItemCreated"
        OnItemDataBound = "EFRPatientReferrals_DataBound">
        
        <HeaderTemplate>
            <table id="PatientReferralResults">
        </HeaderTemplate> 
        
        <SeparatorTemplate> 
            <tr>
                <td>
                    &nbsp; 
                </td>
            </tr>
        </SeparatorTemplate> 
        <ItemTemplate>      
            <asp:HiddenField ID="ReferralIDField" runat="server"  Value='<%# Eval("ReferralId") %>' />
            <asp:HiddenField ID="HiddenFieldPatientId" runat="server" Value='<%# Eval("PatientId") %>' />
            <tr>
                <td class="style3">      
                    <asp:Panel 
                        ID = "ReferralWorkflowsPanel" 
                        runat = "server"  
                        GroupingText = '<%# GroupingText(Eval("ReferralId"), Eval("ReferralStatus")) %>' 
                        Width = "100%" >
                        
                        <table border = "0">

                        <tr>
                            <td style = "width:450px" align = "left" colspan = "2">                                                 
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelforImagingReviewed" 
                                    runat="server" 
                                    AssociatedControlID="LabelImagingReviewedHeader" 
                                    ToolTip="Date Imaging Reviewed by Staff" >
                                    Date Imaging Reviewed by Staff (mm/dd/yyyy):&nbsp;&nbsp;
                                </asp:Label>
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelImagingReviewedHeader" 
                                    runat="server" 
                                    ToolTip="Date Imaging Reviewed by Staff" 
                                    Text='<%# ImagingDateReviewed %>'>
                                </asp:Label>                
                            </td> 
                        </tr>
                        <tr>
                            <td style = "width:450px" align = "left" colspan = "2">                                                 
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelForFragmentVerified" 
                                    runat="server" 
                                    AssociatedControlID="LabelFragmentVerifiedHeader" 
                                    ToolTip="Fragment Verified" >
                                    Fragment Verified:&nbsp;&nbsp;
                                </asp:Label>
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelFragmentVerifiedHeader" 
                                    runat="server" 
                                    ToolTip="Was a Fragment Verified?" 
                                    Text='<%# ImagingFragmentVerified %>'>
                                </asp:Label>                    
                            </td> 
                        </tr>

                        <tr>
                            <td style = "width:450px" align = "left" colspan = "2">                                                 
                                <asp:Label SkinID="DataLabel" runat="server" ID="labelReferralFollowUps"                                    
                                    Text = '<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(BioFollowUpText(Eval("BioFollowUps")))) %>'
                                Width = "450px"  >                                
                            </asp:Label>
                            </td> 
                        </tr>
                            <tr><td>&nbsp;<br/> </td></tr>
                        <tr>
                            <td>                           
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelReferralContactLogs" 
                                Text='<%# SelectContactText(Eval("ContactLogsCount")) %>' 
                                Width = "250px" >
                                
                            </asp:Label>
                                                     
                            </td>
                            <td style = "width:70%" align = "left"> 
                                <table>
                                <tr>
                                <td><asp:Button ID = "btnReferrals" 
                                    CommandName = "Referral" 
                                    runat = "server" 
                                    Text = "Select Referral" />
                                </td>
                                <td><asp:Button ID = "btnContacts" 
                                    CommandName = "ContactLogs" 
                                    runat = "server" 
                                    Text = "Select Contact Entries" />   
                                </td>
                                </tr>
                                <tr>
                                <td><asp:Button ID = "ButtonViewDoDFragmentRawData" 
                                    CommandName = "ViewDoDFragmentRawData" 
                                    Enabled="false" 
                                    runat = "server" 
                                    Text = "Display Source DoD Fragment Data" />      
                                </td>
                                <td><asp:Button ID = "ButtonViewDoDFragment" 
                                    CommandName = "ViewDoDFragment" 
                                    Enabled="false" 
                                    runat = "server" 
                                    Text = "Enter / View DoD Fragment Data" />   
                                </td>
                                </tr>
                                </table>

                             </td>                                                                 
                        </tr>
                        <tr>
                            <td colspan = "2">
                                <asp:Label SkinID="DataLabel" ID = "labelNoWorkflows" Text = "&nbsp;This referral has no workflows" runat = "server"></asp:Label>      
                            </td>                        
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr>
                            <td colspan = "2">
                                <asp:Repeater ID = "ReferralCases" runat = "server"  
                                    OnItemDataBound = "ReferralCases_DataBound">                     
                                                                   
                                    <HeaderTemplate>
                                        <table id="PatientReferralResults" cellspacing="-2" cellpadding="1" width = "100%">           
                                    </HeaderTemplate> 
                                    
                                    <ItemTemplate>
                                        <asp:HiddenField ID="CaseIDField" runat="server" 
                                                Value='<%# Eval("CaseId") %>' />  
                                        <asp:HiddenField ID="CaseTypeIDField" runat="server" 
                                                Value='<%# Eval("CaseTypeId") %>' />
                                        <tr>
                                            <td>
                     
                                            <asp:Panel 
                                                ID = "ReferralCasesPanel" 
                                                runat = "server" 
                                                GroupingText = '<%# GroupingText(Eval("CaseType"), Eval("CaseId"), Eval("CaseStatus")) %>' 
                                                Width = "100%" >   
                                            <table border = "0" cellpadding = "0">
                                            <tr>
                                                <td>
                                                   <asp:GridView 
                                                        ID = "GridViewReferralActivities" 
                                                        runat = "server"                                                         
                                                        SkinID = "Unsortable"  
                                                        AllowPaging = "false" 
                                                        AutoGenerateColumns = "False"  
                                                        DataKeyNames="CaseActivityId, CaseActivityTypeId" 
                                                        AllowSorting="false" 
                                                        OnRowCommand = "ReferralActivities_RowCommand" 
                                                        CssClass="gridRegistry" 
                                                       PagerStyle-CssClass="pager" 
                                                       EmptyDataRowStyle-CssClass="gridRegistryEmpty"
                                                       OnDataBound="GridViewReferralActivities_DataBound">
                                                        <EmptyDataTemplate>
                                                            No data to display
                                                        
                                                        </EmptyDataTemplate> 
                                                        <Columns> 
                                                            <asp:TemplateField HeaderText = "Stage" ItemStyle-Width = "130px" >
                                                            <ItemTemplate>
                                                                <asp:Label 
                                                                    SkinID="DataLabel" 
                                                                    ID = "CaseActivityType" 
                                                                    runat = "server" 
                                                                    Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseActivityType"))) %>'/>
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>
                                                            <asp:TemplateField HeaderText = "Status" ItemStyle-Width = "130px">
                                                            <ItemTemplate>
                                                                <asp:Label 
                                                                    SkinID="DataLabel" 
                                                                    ID = "CaseActivityStatus" 
                                                                    runat = "server" 
                                                                    Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseActivityStatus"))) %>'/>
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>
                                                            <asp:TemplateField HeaderText = "Last Updated" ItemStyle-Width = "100px" >
                                                            <ItemTemplate>
                                                                <asp:Label SkinID="DataLabel" 
                                                                    ID = "LastUpdatedDate" 
                                                                    runat = "server" 
                                                                    Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("UpdatedDate"))) %>'/>
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>                                             
                                                            <asp:TemplateField ItemStyle-HorizontalAlign = "Center" ItemStyle-Width = "75px">
                                                            <ItemTemplate>
                                                                <asp:Button 
                                                                    ID = "SelectActivity" 
                                                                    runat = "server" 
                                                                    Text = "Select" 
                                                                    Visible = '<%# Eval("CaseActivityExists") %>' 
                                                                    CommandName = "ActivityDetails" 
                                                                    CommandArgument = '<%# Container.DataItemIndex %>'/> 
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>
                                                
                                                        </Columns>
                                                    </asp:GridView> 
                                                </td>
                                            
                                            </tr>
                                            
                                            </table>

                                            </asp:Panel>
                                            </td>
                                        </tr>
                                           
                                    </ItemTemplate> 
                                     
                                    <FooterTemplate>
            
                                        <tr>
                                            <td align = "left" >
                                                &nbsp;
                                            </td> 
                                        
                                        </tr>
                                    </table> 
                                    </FooterTemplate>

                                </asp:Repeater>                           
                            </td>                                             
                        
                        </tr>
                                                
                        </table>
                        
                    </asp:Panel> 
                </td> 
            </tr> 
        </ItemTemplate> 
        
        <FooterTemplate>
            
            <tr>
                <td align = "left" >
                    &nbsp;
                </td> 
                
            </tr>
        </table> 
        </FooterTemplate>

    </asp:Repeater> 
    <br /><br /><br /><br />

    <asp:LinkButton ID="LinkButtonPatientInformation" runat="server" Text="Patient Information" ToolTip="Select to see patient information" style="padding:4px; border:1px solid white;" OnClick="LinkButtonPatientInformation_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonRelatedDiagnoses" runat="server" Text="Related Diagnoses" ToolTip="Select to see related diagnoses for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonRelatedDiagnoses_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonLabTests" runat="server" Text="Lab Tests" ToolTip="Select to see lab tests for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonLabTests_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonImages" runat="server" Text="Images" ToolTip="Select to see images for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonImages_Click" />&nbsp;
         
</asp:Content> 